<?php
class Banner{

    private PDO $conn;

    public function __construct(PDO $conn) {
        $this->conn = $conn;
    }

    public function load(){
        $adId = $_REQUEST["adId"] ?? "";
        $placement = $_REQUEST["placement"] ?? "";

        
        if(!$placement){
            return array(
                "error"=>true,
                "msg"=>"Invalid ad placement"
            );
        }

        if(!$adId){
            return array(
                "error"=>true,
                "msg"=>"Invalid device ad id"
            );
        }

        $stmt = $this->conn->prepare("SELECT ba.*, 
                IFNULL(al.click_count, 0) AS click_count,
                        IFNULL(al.show_count, 0) AS show_count
                    FROM banner_ad ba
                    LEFT JOIN (
                        SELECT ad_id, time, g_ad_id,
                        COUNT(action = 'click') AS click_count,
                        COUNT(CASE WHEN action = 'show' AND (SELECT until FROM banner_ad WHERE id = ad_id) = 'frequency' AND TIMESTAMPDIFF(HOUR, time, NOW()) = 0 THEN 1 END) AS show_count
                        FROM ad_log
                        WHERE action IN ('click', 'show')
                        GROUP BY ad_id
                    ) al ON ba.id = al.ad_id AND al.g_ad_id='$adId' 
                    WHERE
                        ((ba.until LIKE '%click' AND IFNULL(al.click_count, 0) < REGEXP_SUBSTR(SUBSTRING_INDEX(ba.until, ' ', 1), '[0-9]+'))
                        OR (ba.until LIKE '%show' AND IFNULL(al.show_count, 0) < REGEXP_SUBSTR(SUBSTRING_INDEX(ba.until, ' ', 1), '[0-9]+'))
                        OR (ba.until = 'frequency' AND IFNULL(al.show_count, 0) < ba.frequency)
                        OR ba.until = 'always') 
                        AND (ba.placement='$placement' OR ba.placement='all')
                        AND status=1
                    ORDER BY RAND()
                    LIMIT 1");

        if($stmt->execute()){
            if($stmt->rowCount()>0){
                $ad = $stmt->fetch(PDO::FETCH_ASSOC);
                return array(
                    "error"=>false,
                    "msg"=>"Add loaded successfully",
                    "data"=>$ad
                );
            }else{
                return array(
                    "error"=>true,
                    "msg"=>"No fill"
                );
            }
        }else{
            return array(
                "error"=>true,
                "msg"=>"Something went wrong"
            );
        }

    }

    public function updateStatus(){
        $bannerId = $_REQUEST["bannerId"] ?? "";
        $action = $_REQUEST["action"] ?? "";
        $adId = $_REQUEST["adId"] ?? "";


        if(!$bannerId){
            return array(
                "error"=>true,
                "msg"=>"Banner id invalid"
            );
        }

        if(!$adId){
            return array(
                "error"=>true,
                "msg"=>"Ad id is invalid"
            );
        }

        $stmt  = $this->conn->prepare("INSERT INTO ad_log (action, g_ad_id, ad_id) VALUES('$action', '$adId', '$bannerId' )");
        if($stmt->execute()){
            return array(
                "error"=>false,
                "msg"=>"Update action successfully"
            );
        }else{
            return array(
                "error"=>true,
                "msg"=>"Update action failed"
            );
        }
    }
}